/* ---------------------------------------------------------------------------
    2019 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

package ui;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

// ----------------------------------------------------------------------------------
//	Class SelectionDialog
//	Popup asking to choose an entry in a list of objects. 
//----------------------------------------------------------------------------------
public class SelectionDialog  extends JDialog implements ActionListener 
{
	private static final long serialVersionUID = 1L;
	private JButton m_okButton = new JButton("OK");
	private JButton m_cancelButton = new JButton("Cancel");
	private JComboBox<String> m_comboBox;
	private boolean m_isOk = false;
	
	public String	m_sSelection = new String("");
	public int		m_selectionIdx = 0;
	
	//	Constructor
	public SelectionDialog(JFrame aFrame, String aTitle, String [] ReaderList)
	{
	    super(aFrame, aTitle, true);
	    
	    m_comboBox = new JComboBox<String>(ReaderList);
	    m_okButton.addActionListener(this);
	    m_cancelButton.addActionListener(this);
	    
	    setMinimumSize(new Dimension(200, 120));
	    
	    setupUi();
	    
	    Point frameLoc = aFrame.getLocation();
	    Dimension frameDim = aFrame.getSize();
	    pack();
	    setLocation(frameLoc.x+(frameDim.width-getWidth())/2, frameLoc.y+(frameDim.height-getHeight())/2);
	    
	    addWindowListener(new WindowAdapter() 
	    {
	      public void windowClosing(WindowEvent e) 
	      {
	    	  e.getWindow().dispose();
	      }
	    }
	    );
	    
	    getRootPane().setDefaultButton(m_okButton);
	    
	    setVisible(true);
	}
	
	public void setupUi()
	{
		getContentPane().setLayout(new GridBagLayout());
		
		GridBagConstraints c = new GridBagConstraints();
		int insUnit = 5;
		
		c.fill = GridBagConstraints.BOTH;
		
		c.weightx = 1;
	    c.gridx = 0;
	    c.gridy = 0;
	    c.gridwidth = 2;
	    c.weighty = 5.0;
	    c.insets = new Insets(insUnit, insUnit, insUnit, insUnit);
	    add(m_comboBox, c);
	    
	    c.weightx = 1;
	    c.gridx = 0;
	    c.gridy = 1;
	    c.gridwidth = 1;
	    c.weighty = 1.0;
	    c.insets = new Insets(0, insUnit, insUnit, insUnit);
	    add(m_okButton, c);
	    
	    c.weightx = 1;
	    c.gridx = 1;
	    c.gridy = 1;
	    c.gridwidth = 1;
	    c.weighty = 1.0;
	    c.insets = new Insets(0, 0, insUnit, insUnit);
	    add(m_cancelButton, c);
	}
	
	public void actionPerformed(ActionEvent evt) 
	{
	    if (evt.getSource() == m_okButton)
	    {
	    	//	The user has pushed the ok button
	    	m_isOk = true;
	    	
	    	//	Retrieve the selected item
	    	m_sSelection = (String) m_comboBox.getSelectedItem();
	    	m_selectionIdx = m_comboBox.getSelectedIndex();
	    }
	    
		setVisible(false);
	    dispose();
	}

	public boolean isOk()
	{
		return m_isOk;
	}
} // end class
